-- origins.lua

-- Library location library. 

local origins = {}
getfenv(0).origins = origins

origins.defaultFileName = "_origins_data.lua"

origins.data = {}

local origins_save_metatable = {
--Figure_newIndex--
	__newindex = function( table, key, value )
--		print( "newindex: ", key )
		origins.data[key] = origins.currentFilename
		rawset( table, key, value )
	end,
--Figure_end--	
--Figure_index--
	__index = function( table, key )
--		print( "   index: ", key )
		local source = origins.data[key]
		if source then
			origins.original_require( source )
		end
		return rawget( table, key )
	end,
--Figure_end--
}

--Figure_requireHook--
function origins.new_require( name, ... )
	if origins.currentFilename ~= nil then
		-- already inside a require() -- keep loading as usual
		origins.original_require( name, unpack( arg ))
	else
		print( "processing "..name )
		-- keep track of context
		origins.currentFilename = name
		origins.original_require( name, unpack( arg ))
		origins.currentFilename = nil
	end
end
--Figure_end--

--Figure_startWatching--
function origins:startWatching()
	origins.original_require = require
	require = origins.new_require
	setmetatable( getfenv(0), origins_save_metatable )
end

function origins:stopWatching()
	setmetatable( getfenv(0), nil )
	require = origins.original_require 
end
--Figure_end--

--Figure_saveData--
function origins:saveData( filename )
	self:stopWatching()

	filename = filename or self.defaultFileName
	local fout = io.open( filename, 'wt' )
	fout:write( "-- generated in "..os.date().." by origins\n" )
	
	fout:write( "origins.data = {\n" )
	for i,v in pairs( self.data ) do
		fout:write( string.format( 
			"\t[%q] = %q,\n",
			i, v )
		)			
	end
	fout:write( "}\n" )
	
	fout:close()
end
--Figure_end--

--Figure_loadData--
function origins:loadData( filename )
	filename = filename or self.defaultFileName
	print( "loading "..filename )
	dofile( filename )
	origins:startWatching()
end
--Figure_end--

local tbl = {}
setmetatable( tbl, origins_save_metatable )
tbl.abcd = 1
print( tbl.abcd )